#!/usr/bin/env python3
import json, sys, os, time
if len(sys.argv)<2: sys.exit("usage: python3 scripts/t3_progress.py <lenses|randoms>")
p=f"data/prestack_progress_{sys.argv[1]}.json"
if not os.path.exists(p): sys.exit("No progress file yet.")
try:
  while True:
    s=json.load(open(p)); d, t = s.get("done",0), s.get("total",0)
    pct=(d/t*100) if t else 0; eta=s.get("eta_sec")
    print(f"{sys.argv[1]}: {d}/{t} bins ({pct:4.1f}%)  ETA: {eta}s  elapsed: {s.get('elapsed_sec')}")
    time.sleep(5)
except KeyboardInterrupt:
  pass
